/* test of a fragment of colp */
/* this program will be scaled up to a "broker" */

#include <sys/types.h> 
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "colcserver.h"  


/* convert term to list representation */
/* i.e., capp (capp A B) C to A->B->C */
/* note: not recursive! */
struct cterm *serializeterm(struct cterm *term)
{ struct cterm * cur, *ax, *temp;
  cur = term;  ax = NULL;
  if (cur == NULL) return NULL;
  while (cur->ctype == APP)
    { 
      (cur->val.appval).right->next = ax;
      ax = cur->val.appval.right;
      cur = cur->val.appval.left;
    }
  cur->next = ax;
  return cur;
}  /* serializeterm */


void printsterm(struct cterm * cur)
{
  if (cur == NULL) printf("\n");
  else 
   {
     printf("%d ",cur->ctype);
     printsterm(cur->next);
   }
}

void dealloc(struct cterm *term)
{
  if (term == NULL) return;
  if (term->ctype == APP) { dealloc(term->val.appval.left);
                            dealloc(term->val.appval.right);
                          }
  if (term->ctype == ABS)  /* not implemented currently */
    dealloc(term->val.absval);
  if (term->next) dealloc(term->next);
  free(term);
}

struct cterm *nthterm(struct cterm *term, int n)
{
  if (n<1) return term;
    else return nthterm(term->next,n-1);
}

/* the tau translation for C */

/* this is the main procedure: does actual dispatch */
/* must do repeatedly until normal form is reached */
struct cterm * tocterm(struct cterm *term)
{ int id;
  void * myf;  /* pointer to a function */
  struct cterm *pterm, *headterm;
  /*  if (term->ctype != APP) return term; */
  if ((term->ctype == APP) || (term->ctype == ID)) 
    {
  pterm = serializeterm(term);
  /*  printsterm(pterm); */
  headterm = nthterm(pterm,0);
  id = headterm->val.ival;   /* head */
  myf = match[id];   /* need bounds check */
  term = (* (struct cterm* (*)(struct cterm *))myf)(pterm);
    }
  return term;
}

void writecterm(struct cterm *t, char *response)
{
  char aleft[HALFBUF]; char aright[HALFBUF];
  switch (t->ctype)
    {
      case CIC:
	sprintf(response,"(cic %d)",t->val.ival); break;
      case CRC:
        sprintf(response,"(crc %.4f)",t->val.dval); break;
      case CSC:
        sprintf(response,"(csc \"%s\")",t->val.sval); break;
      case ID:
        sprintf(response,"(id %d)",t->val.ival); break;
      case APP:
	writecterm(t->val.appval.left,aleft);
	writecterm(t->val.appval.right,aright);
	sprintf(response,"(capp %s %s)",aleft,aright); break;
      default: break;  /* INCOMPLETE  -, CABS, IND*/
    }  /* switch */
  if (t) dealloc(t);
}


int toint(struct cterm *term)
{ 
  if (term->ctype == CIC)
       return term->val.ival;
  else return toint(tocterm(term));
}

double todouble(struct cterm *term)
{ 
  if (term->ctype == CRC)
     return term->val.dval; 
  else return todouble(tocterm(term));
}

char * tostring(struct cterm *term)
{ 
  if (term->ctype == CSC) return term->val.sval; 
    else return tostring(tocterm(term));
}


struct cterm *mkappterm(struct cterm* left, struct cterm* right)
{
  struct cterm *s;
  s = (struct cterm*)malloc(sizeof(struct cterm));
  s->next = NULL;
  s->ctype = APP;
  s->val.appval.left = left;
  s->val.appval.right = right;
  return s;
}

struct cterm *app1(int leftID, struct cterm* right)
{
  struct cterm *s;
  s = (struct cterm*)malloc(sizeof(struct cterm));
  s->next = NULL;
  s->ctype = APP;
  s->val.appval.left = idtocterm(leftID);
  s->val.appval.right = right;
  return s;
}


struct cterm *mkapp2(struct cterm* f, struct cterm* r1,
		     struct cterm* r2)
{
  struct cterm *s1, *s2;
  s1 = (struct cterm*)malloc(sizeof(struct cterm));
  s2 = (struct cterm*)malloc(sizeof(struct cterm));
  s1->ctype = APP; s2->ctype = APP;
  s1->next = NULL; s2->next = NULL;
  s2->val.appval.left = f;
  s2->val.appval.right = r1;
  s1->val.appval.left = s2;
  s1->val.appval.right = r2;
  return s1;
}

// does not allow inds, restricted to first order
struct cterm *app2(int fID, struct cterm* r1,
		     struct cterm* r2)
{
  struct cterm *s1, *s2;
  s1 = (struct cterm*)malloc(sizeof(struct cterm));
  s2 = (struct cterm*)malloc(sizeof(struct cterm));
  s1->ctype = APP; s2->ctype = APP;
  s1->next = NULL; s2->next = NULL;
  s2->val.appval.left = idtocterm(fID);
  s2->val.appval.right = r1;
  s1->val.appval.left = s2;
  s1->val.appval.right = r2;
  return s1;
}

struct cterm *idtocterm(int i)
{
  struct cterm *s;
  s = (struct cterm*)malloc(sizeof(struct cterm));
  s->next = NULL;
  s->ctype = ID;
  s->val.ival = i;
  return s;  
}


struct cterm* itocterm(int x)
{
  struct cterm *s;
  s = (struct cterm*)malloc(sizeof(struct cterm));
  s->next = NULL;
  s->ctype = CIC;
  s->val.ival = x;
  return s;  
}

struct cterm* dtocterm(double x)
{
  struct cterm *s;
  s = (struct cterm*)malloc(sizeof(struct cterm));
  s->next = NULL;
  s->ctype = CRC;
  s->val.dval = x;
  return s;  
}

struct cterm* stocterm(char* x)
{
  struct cterm *s;
  s = (struct cterm*)malloc(sizeof(struct cterm));
  s->next = NULL;
  s->ctype = CSC;
  sprintf(s->val.sval,"%s",x);  /* STRING COPIED! */
  return s;  
}


void skipblank(char ** buffer, int *i)
{
  while (**buffer == ' ') {*buffer += 1; *i += 1; }
}

/* temporary parser - reads string into cterm structure*/
struct cterm * colparse(char* buffer, int *size)
{  char token[128]; char single;
   int i = 0;  int result;
   struct cterm * sub1, * sub2, * term;
   term = (struct cterm *) malloc(sizeof(struct cterm));
   term->next = NULL; 
   skipblank(&buffer,&i);
   result = sscanf(buffer,"%s",token);
   if (result < 1) return NULL;
   i += strlen(token);
   buffer += strlen(token);
   skipblank(&buffer,&i);
   if (!strcmp(token,"cic"))            /* cic  */
       {
          term->ctype = CIC;
          result = sscanf(buffer,"%s",token);  
          buffer += strlen(token);  skipblank(&buffer,&i); 
          i += strlen(token);
	  /*   printf("seen cic %s\n",token);  */
          term->val.ival = atoi(token);
       }
   if (!strcmp(token,"id"))            /* id  */
       {
          term->ctype = ID;
          result = sscanf(buffer,"%s",token);
          buffer += strlen(token);  skipblank(&buffer,&i); 
          i += strlen(token);
          term->val.ival = atoi(token);
	  /*       printf("seen id %s\n",token); */
       }
   if (!strcmp(token,"csc"))            /* csc */  
       {  int j = 0; char ct = ' ';
          term->ctype = CSC;
	  /*          result = sscanf(buffer,"%s",token);   includes "" */

          skipblank(&buffer,&i);  buffer++; i++;  /* skip " */
          while (ct != '\"')
	    {
	      sscanf(buffer,"%c",&ct);
	      if (ct != '\"') token[j] = ct; else token[j] = 0;
	      buffer++; i++; j++;
	    }
	  /*
          buffer += strlen(token);   skipblank(&buffer,&i); 
          i += strlen(token);
	  */
	  sprintf(term->val.sval,"%s",token);
	  /*	  term->val.sval[strlen(token)-2] = 0;  */
	  /*   printf("seen csc \"%s\"\n",token);  */
       }
   if (!strcmp(token,"crc"))            /* crc  */
       {
          term->ctype = CRC;
          result = sscanf(buffer,"%s",token);
          buffer += strlen(token);   skipblank(&buffer,&i); 
          i += strlen(token);
          term->val.dval = atof(token);
	  /*  printf("seen crc\n"); */
       }
   if (!strcmp(token,"capp"))
       {  int sa, sb;
          term->ctype = APP;
          sub1 = colparse(buffer,&sa);
          buffer += sa;    i += sa;  skipblank(&buffer,&i); 
          sub2 = colparse(buffer,&sb);
          buffer += sb;      i += sb; skipblank(&buffer,&i);
          term->val.appval.left = sub1;
          term->val.appval.right = sub2;
	  /*  printf("seen app\n"); */
       }
   *size = i;
   return term;
}


int main(int argc, char** argv)
{
  int sfd, cfd, len;
   FILE * readstream = NULL;  
   FILE * writestream = NULL;
   struct sockaddr_in caddr;  
   struct sockaddr_in saddr;  
   int result = 1;
   char request[BUFSIZE];
   char response[BUFSIZE];

   inittable();

   /* listening socket */
         sfd = socket(AF_INET, SOCK_STREAM, 0);  
         if (sfd == -1) exit(1);
         saddr.sin_family = AF_INET;
         saddr.sin_addr.s_addr = htonl(INADDR_ANY);
         saddr.sin_port = htons(COLPORT);
         len = sizeof(saddr);
         setsockopt(sfd,SOL_SOCKET,SO_REUSEADDR,&result,sizeof(int));
	 result = bind(sfd, (struct sockaddr *) &saddr, len);  
         if (result < 0) { perror("bind failed\n"); exit(1); }
         listen(sfd,32);
         printf("\nCOL C server waiting ...\n");

 while (1<2)
   {
         cfd = accept(sfd, (struct sockaddr *) &caddr, &len);
         readstream = fdopen(cfd,"r");
         if (readstream == NULL) exit(1);
         writestream = fdopen(dup(cfd),"w");
         if (writestream == NULL) exit(1);

	 result = 1;
         while (result > 0)
	 {
         result = read(cfd,request,256);
         if (result > 0) 
	   { int temp, size;
   	     struct cterm * interm;
	     request[result] = 0;  /* 0-terminate to be sure */

   /* get rid of parens */
   for(temp=0;temp<strlen(request)+1;temp++)
     if (request[temp] == '('  || request[temp] == ')') request[temp] = ' ';

   /*             printf("got string %s from client of length %d\n",request,
		    strlen(request));  
   */
             
	     interm = colparse(request,&size);
	     writecterm(tocterm(interm),response);
             temp = strlen(response);
             response[temp+2] = 0;
	     response[temp] = '.';
	     response[temp+1] = '$';
             write(cfd,response,temp+3);
     	     dealloc(interm);
	     /*         printf("wrote response %s to client\n",response);  */
	   }  /* if */
   	    fflush(readstream);  
            fflush(writestream);
	 } /* server session while loop */
	 fclose(readstream);
	 fclose(writestream);
	 close(cfd);
   } /* accept loop */
	 exit(0);
}



/*  GENERAL SETUP  (it's complicated!)
   colparse gives cterm
   toterm evals it by:
     serialize it (spine form)
     invokes generated colc dispatch fun
     colc dispatch fun calls toint, tostring, etc.. on each arg,
       which in term calls toterm recursively if they have to.
     colc fun calls the user-defined function,
     colc fun finally calls itocterm,  or stocterm, etc
     to generate the cterm to be returned.
     writecterm finally prints it.
 */
