module colgram.
accumulate lambdayacc, corecol.

non_terminal X :- member X [csig A,idlist B,tdec C T,kdec D,ctexp E,dpart F].
ntnum 6.
terminal X :- 
  member X [lparen,rparen,(iconst V),(id S),(sconst St),colont,arrowt,
            intt, realt, stringt, boolt,typet,kindt,commat].

%%% tokenizer declarations:
printname _ "(" lparen.
printname _ ")" rparen.
printname _ "->" arrowt.
printname _ ":" colont.
printname _ "type" typet.
printname _ "kind" kindt.
printname _ "," commat.
printname _ "->" arrowt.
printname _ "int" intt.
printname _ "real" realt.
printname _ "string" stringt.
printname _ "bool" boolt.

% id, iconst, sconst are universal

start_symbol (csig X).  % parser returns definition of regular module

cfg
[ rule ((ctexp T1) ==> [intt])  (T1 = cint),
  rule ((ctexp T2) ==> [realt])  (T1 = creal),
  rule ((ctexp T3) ==> [stringt])  (T1 = cstring),
  rule ((ctexp T4) ==> [boolt])  (T1 = cbool),
  rule ((ctexp T5) ==> [ctexp T6,arrowt,ctexp T7])  (T5 = (cr T6 T7)),
  rule ((ctexp T9) ==> [lparen,ctexp T10,rparen])  (T9 = T10),
  rule ((ctexp T11) ==> [id T12]) (T11 = stid T12),
  
  rule ((tdec L1 S1) ==> [dpart L2,ctexp S2])  (L1 = L2, S1 = S2),

  rule ((kdec S3) ==> [dpart L3,typet]) (S3 = L3),
  rule ((csig C1) ==> [kdec C1k]) (formkdecs C1k C1),
  rule ((csig C2) ==> [tdec C1a C1b]) (formtdecs C1a C1b C2),
  rule ((csig C3) ==> [csig C3h,kdec C3k])
		(formkdecs C3k K3, append C3h K3 C3),
  rule ((csig C4) ==> [csig C4h,tdec C3a C3b])
		(formtdecs C3a C3b Ct, append C4h Ct C4),

  rule ((idlist IDL1) ==> [id IDLa])	(IDL1 = [IDLa]),
  rule ((idlist IDL2) ==> [idlist IDL3,commat,id IDLb]) 
		(append IDL3 [IDLb] IDL2),
  rule ((dpart IDL4) ==> [idlist IDL5,colont])  (IDL4 = IDL5)
].

binaryop arrowt (ctexp A) (ctexp B) "right" 6.  

formkdecs [] [].
formkdecs [H|T] [kinddec H|M] :- formkdecs T M.
formtdecs [] T [].
formtdecs [A|R] T [typedec A T|R2] :- formtdecs R T R2.

% freshcopy : needed!

freshcopy (ctexp A) (ctexp B) :- !.
freshcopy (tdec A C) (tdec B D) :- !.
freshcopy (kdec A) (kdec B) :- !.
freshcopy (idlist A) (idlist B) :- !.
freshcopy (csig A) (csig B) :- !.
freshcopy (dpart A) (dpart B) :- !.
freshcopy T T.


