sig corecol.

% First define the COL as an ordinary object language:

kind ctype type.    % col types.
kind cterm type.    % col terms.

type tid int -> ctype.  % type identifiers
type cint, cstring, creal, cbool ctype.
type clist ctype.
type cr ctype -> ctype -> ctype.  % col functional types
type cp ctype -> ctype -> ctype.  % col product types

% COL terms  (abstractions use de Brujin representation)  

type cnil cterm.
type ccons cterm -> cterm -> cterm.  % pairs
type cic int -> cterm. % integer constants
type csc string -> cterm.  % string constants
type crc real -> cterm.    % real constants
type cid int -> cterm.	% term-level identifiers
type capp cterm -> cterm -> cterm.  % application
type ind int -> cterm.  % de Bruijn index (bound variable)
type cabs cterm -> cterm.  % abstractions

type tau ctype -> cterm -> A -> int -> o.

% First arg is the type of the cterm, on which tau is indictively defined.
% Second arg is the COL term.
% Third arg is the meta-level Lambda Prolog term that matches a specific
%    COL signature.
% Fourth arg is the embedding level, used to calculate de Bruijn indices.

% predicate used to assign integers to identifiers:
type imatch A -> int -> o.
type smatch string -> int -> o.

% distinguish terms such as (f 3) from 4:
% meta compilers will write compound (f A).
type compound A -> o.


% added for parser generation:
kind decl type.
type typedec string -> ctype -> decl.
type kinddec string -> decl.
type stid string -> ctype.  %(temporary type identifier)

type copyty ctype -> ctype -> o.
type copydecl decl -> decl -> o.










