#include "folistssrv.h"
#include <math.h>
#include <stdlib.h>

struct tuple
{ int head;
  struct tuple * tail;
};

void freetuple(struct tuple* t);
void printtuple(struct tuple* t);


struct tuple* nul() { return NULL; }

struct tuple* new(int x, struct tuple* t)
{ struct tuple* n;
  n = (struct tuple*)malloc(sizeof(struct tuple));
  n->head = x;  n->tail = t;
  return n;
}

/* totuple and tuple2cterm are hard to write because I didn't use
the pre-defined functions mkappterm and mkappterm2, which hides
many of the details.  A way to simplify this, and to preserve
transparency to a higher degree, may be to include ml-style datatype
declarations in the COL signature itself.  Alternatively, we can
allow certain identifiers to be designated constructors, as in

        constructor new : int -> tuple -> tuple

It should then be possible to generate the functions tuple2cterm 
and totuple automatically.
*/

struct tuple* totuple(struct cterm* c)
{ 
  c = serializeterm(c);
  if ((c->ctype == ID) && (c->val.ival == nulID))
    return nul();
  else if ((c->ctype == ID) && (c->val.ival == newID) && (c->next))
    return new(toint(c->next),totuple(c->next->next));
  else return totuple(tocterm(c));
}

struct cterm* tuple2cterm(struct tuple* t)
{  struct cterm * c;
   if (t == NULL) 
     c = idtocterm(nulID);
   else
     c = app2(newID,itocterm(t->head),tuple2cterm(t->tail));
   if (t) free(t);
   return c;
}

/*  tuple auxiliaries */
void freetuple(struct tuple* t)
{ if (t) { freetuple(t->tail);
           free(t);
         }
}

void printtuple(struct tuple* t)
{ if (t) { printf("%d ",t->head); printtuple(t->tail); }
  else printf("\n");
}

/* -------------- */

int size(struct tuple* t)
{  if (t==NULL) return 0; else return 1 + size(t->tail); }

int sqr(int x) { return x*x; }
int plus(int x, int y) { return x+y; }
int times(int x, int y) { return x*y; }
char* getstring()
  { return getenv("USER"); }


/* test: tjsim folists:

open_col_session "localhost" S,
X = (new 2 (new 3 (new 5 (new 7 nul)))),
remote_eval S (size X) Z,
close_col_session S.

*/





