; implementation of lists.col server functions

(load "lists.sch") ; load file generated by msc


; convert from local lists to tuples lists:
(define (fromlist L)
(define (fromlist2 L)
    (if (null? L) 'nul
       (cons (list 'new (car L)) (list (fromlist2 (cdr L))))))
 (let ((m (fromlist2 L)))
   (if (eq? 'nul (car m)) 'nul m)))

; might be useful:
(define (uncurrie2 cf)
  (define (f x y) ((cf x) y))
f)


; implement functions defined in COL signature

; Note: although one uses normal scheme structures, all COL-compliant
; functions must be in Curried form.
; This is partly due to MIT Scheme's questionable descision to make
; (f a b) not equivalent to ((f a) b).

(define nul ())    

; new (cons) differs from others since it doesn't have a mynew.
; this is because COL doesn't inherently support list type.
; Here, new is just rewritten as a Curried form of cons:

(define new (lambda (H) (lambda (T) (cons H T))))


; mysqr not needed since int already a COL-recognized type.
(define (sqr N) (* N N))

(define plus (lambda (x) (lambda (y) (+ x y))))
(define times (lambda (x) (lambda (y) (* x y))))

(define size (lambda (L) (length L)))

; needed to avoid writing Curried code all over the place:
(define (myfold F L)
   (if (null? L) 0
     (if (null? (cdr L)) (car L)
       ((F (car L)) (myfold F (cdr L))))))
(define fold (lambda (F) (lambda (L) (myfold F L))))


; this is needed since tmap returns a list such as ((new 3) nul)
(define (mytmap F L)
   (if (null? L) L
      (cons (F (car L)) (mytmap F (cdr L)))))
(define mapfn (lambda (F) (lambda (L) (fromlist (mytmap F L)))))

; whole thing relies on inner-most first evaluation




