% COL - C Meta-Compiler.

module mcc.
accumulate colsigparser.  % accumulates colgram accumulates corecol


type primitive ctype -> o.
primitive cint.
primitive creal.
primitive cstring.
primitive cbool.
primitive (stid S).
primitive (tid N).

type sid string -> cterm.  % intermediate abstract syntax
type postau 
	out_stream -> ctype -> ctype -> string -> int -> o.

% to is original type.
postau OM To T F 0 :- primitive T,
   mapctype T _ _ Ttoc,
   output OM "  return ", output OM Ttoc, output OM "(",
   output OM F, output OM "(", output OM "));\n".      
postau OM To T F I :- primitive T, I > 0, 
   targettype To Tg,
   mapctype _ Tg _ Ttoc, !, 
   output OM "  return ", output OM Ttoc, output OM "(",
   output OM F, output OM "(",
   makeargs To 0 Targs,
   output OM Targs, output OM "));\n".
postau OM To (cr A B) F I :- I1 is (I + 1),
   term_to_string I1 Is,
   Var is ("x" ^ Is),
   mapctype A _ TOA _,
   output OM "  ",  output OM Var, output OM " = ",
   output OM TOA, output OM "(nthterm(term,", printterm OM I1,
   output OM "));\n",
   postau OM To B F I1.
  
type makeargs ctype -> int -> string -> o.
makeargs (cr A B) I As :- primitive B,  % reached target type
  I1 is (I + 1), term_to_string I1 Is, 
  As is ("x" ^ Is).
makeargs (cr A (cr B C)) I As :- I1 is (I + 1),
  term_to_string I1 Is,
  makeargs (cr B C) I1 Bs,
  As is ("x" ^ Is ^ "," ^ Bs).


%top level predicate use two-pass to generate inittable and service funs
colcmc Sig :-
  S2 is (Sig ^ ".col"),
  parsefile S2 (csig CS),
  LSig is (Sig ^ "srv.h"),
  LMod is (Sig ^ "srv.c"),
  open_out LSig LS, open_out LMod LM,
  output LS "/* This file was automatically generated by mcc */\n\n",
  output LM "/* This file was automatically generated by mcc */\n\n",
  output LS "#include \"colcserver.h\"\n\n",
  output LM "#include \"", output LM LSig, output LM "\"\n\n",
  output LM "void inittable()\n{\n",
  metatable LS LM CS 0,
  output LM "}\n\n\n",
  metacompile LS LM CS 0,
  close_out LS,  close_out LM.


type  metatable  (out_stream -> out_stream -> list decl -> int -> o).
metatable OS OM [] L.
metatable OS OM [kinddec T|R] L :-  L1 is (L + 1), % TEMP!
  metatable OS OM R L1.

metatable OS OM [typedec F T0|R] L :- L1 is (L + 1),
  Myf is ("colc" ^ F),
  output OM "  match[", printterm OM L, output OM "] = (void*) ",
  output OM Myf, output OM ";\n",
  metatable OS OM R L1.

% assignment of indices to id's must be carefully maintained consistent

type  metacompile  (out_stream -> out_stream -> list decl -> int -> o).
metacompile OS OM [] L.
metacompile OS OM [kinddec T|R] L :- L1 is (L + 1),
  output OS "struct ", output OS T, output OS ";\n",
  output OS "struct cterm* ", output OS T, 
  output OS "2cterm(struct ", output OS T, output OS "*);\n",
  output OS "struct ", output OS T, output OS "* to",
  output OS T, output OS "(struct cterm *);\n",
  output OS "#define ", output OS T, output OS "TID ",
  printterm OS L, output OS "\n\n",
  KS is ("struct " ^ T ^ "*"),
  TOK is ("to" ^ T),
  K2C is (T ^ "2cterm"),
  (copyty (stid T) (tid L) =>
    (mapctype (tid L) KS TOK K2C => metacompile OS OM R L1)).
metacompile OS OM [typedec F T0|R] L :- L1 is (L + 1),
  copyty T0 T,
  Myf is ("colc" ^ F),
  arity T Ta, targettype T Tg,
  output OS Tg, output OS " ", output OS F,
  output OS "(",
  toctype T Ta TS 0, output OS TS,
  output OS ");\n",
  output OS "struct cterm * ", output OS Myf,
  output OS "(struct cterm *);\n",
  output OS "#define ", output OS F, output OS "ID ", 
  printterm OS L, output OS "\n\n",
  % generate dispatch function 
  output OM "struct cterm * ", output OM Myf,
  output OM "(struct cterm *term)\n{\n",
  makedecs OM T 0,
  postau OM T T F 0,   
  output OM "}\n\n",
  metacompile OS OM R L1.

type  makedecs  (out_stream -> ctype -> int -> o).
makedecs OM T I :- primitive T.
makedecs OM (cr A B) I :- I1 is (I + 1),
  mapctype A CA _ _,
  term_to_string I1 Is, Var is ("x" ^ Is),
  output OM CA, output OM " ", 
  output OM Var, output OM ";\n",
  makedecs OM B I1.

% convert col type to string rep of meta-level type.
type toctype ctype -> int -> string -> int -> o.
toctype T 0 "" I.
toctype (cr T Tf) N CT I :- primitive Tf, mapctype T CT _ _.
toctype (cr A B) N TS I :- I1 is (I + 1), N1 is (N - 1),
  mapctype A CA _ _,
  toctype B N1 RS I1,
  TS is (CA ^ ", " ^ RS).


% maps ctype to c type and names of tau functions
% first-order only  
type mapctype ctype -> string -> string -> string -> o.   
mapctype cint "int" "toint" "itocterm".
mapctype creal "double" "todouble" "dtocterm".
mapctype cstring "char*" "tostring" "stocterm".
mapctype cbool "int" "toint" "itocterm".
%mapctype (tid N) "void*" "toint" "itocterm".


type targettype ctype -> string -> o.
targettype T Ts :- primitive T, mapctype T Ts _ _.
targettype (cr A B) T :- targettype B T.


% utils

type arity ctype -> int -> o.
arity T 0 :- primitive T.
arity (cr A B) T :- arity B S, T is (S + 1).

