% COL - Lambda Prolog Meta-Compiler.
% This is independent of collp.mod, which is the object language here,
% despite similarities.

module mclp.
accumulate colsigparser.  % accumulates colgram accumulates corecol


type primitive ctype -> o.
primitive cint.
primitive creal.
primitive cstring.
primitive cbool.
primitive (stid S).
primitive (tid N).

type sid string -> cterm.  % intermediate abstract syntax
type postau, negtau 
	out_stream -> cterm -> string -> ctype -> int -> string -> o.


postau OS N F T I L :- primitive T,
  makestring N Ns,
  output OS "(tau (", printterm OS T, output OS ") ",
  output OS Ns, output OS " ",
  output OS F, output OS " ", output OS L, output OS ")".
  
negtau OS N F T I L :- primitive T, postau OS N F T I L.


% non-primitive types:

postau OS N F (cr A B) I L :-  I1 is (I + 1),
  gensym "U" I1 U, gensym "V" I1 V, Up is (U ^ "p"),
  output OS "pi ", 
  output OS U, output OS "\\ (pi ",
  output OS Up, output OS "\\ (pi ",  % needed if U = cabs Up
  output OS V, output OS "\\ ( ",
  output OS "(", negtau OS (sid U) V A I1 L, output OS ") ",
  output OS "=> (",   
  Fv is ("(" ^ F ^ " " ^ V ^ ")"),
  postau OS (capp N (sid U)) Fv B I1 L,
  output OS ") )))".

negtau OS (sid S) F (cr A B) I L :-
  Sp is (S ^ "p"), 
  output OS "(((cabs ", output OS Sp, output OS ")",
  output OS " = ", output OS S, output OS "), (",
  negtau OS (cabs (sid Sp)) F (cr A B) I L,
  output OS "))".
  
negtau OS (cabs S) F (cr A B) I L :- I1 is (I + 1),
  gensym "v" I1 V, gensym "L" I1 L1, gensym "M" I1 M,
  gensym "N" I1 N,
  output OS "pi ", output OS V, output OS "\\ ( (",
  output OS "pi ", output OS M, output OS ":int\\ (",
  output OS "pi ", output OS N, output OS ":int\\ ( (",
  output OS N, output OS " is (", output OS M,
  output OS " - ", output OS L, output OS ")) => ",
  IndN is ("(ind " ^ N ^ ")"),
  postau OS (sid IndN) V A I1 M, output OS "))) => ( (",
  output OS L1, output OS " is (", output OS L,
  output OS " + 1)), ",
  Fv is ("(" ^ F ^ " " ^ V ^ ")"),
  negtau OS S Fv B I1 L1, output OS ") )".

%want pi M\ pi N\ ( (N is (M - L)) => ...


%top level predicate
collpmc Sig :-
  S2 is (Sig ^ ".col"),
  parsefile S2 (csig CS),
  LSig is (Sig ^ ".sig"),
  LMod is (Sig ^ ".mod"),
  open_out LSig LS, open_out LMod LM,
  output LS "%% This file was automatically generated by mclp \n\n",
  output LM "%% This file was automatically generated by mclp \n\n",
  output LS "sig ", output LS Sig, output LS ".\n",
  output LS "accum_sig collp.\n\n",
  output LM "module ", output LM Sig, output LM ".\n",
  output LM "accumulate collp.\n\n",
  metacompile LS LM CS 0,
  close_out LS,  close_out LM.

type  metacompile  (out_stream -> out_stream -> list decl -> int -> o).
metacompile OS OM [] L.
metacompile OS OM [kinddec T|R] L :- L1 is (L + 1),
  output OS "kind ", output OS T, output OS " type.\n",
  (copyty (stid T) (tid L) => metacompile OS OM R L1).
metacompile OS OM [typedec F T0|R] L :- L1 is (L + 1),
  copyty T0 T,
  tomtype T Tm,
  output OS "type ", output OS F, output OS " ",
  output OS Tm, output OS ".\n",
  output OM "pi L:int\\ (",
  postau OM (cid L) F T 0 "L",
  output OM ").\n",
  arity T Ta,  mkcompound F Ta CS,
  output OM CS, output OM "\n",
  metacompile OS OM R L1.


% convert col type to string rep of meta-level type.
type tomtype ctype -> string -> o.
tomtype cint "int".
tomtype creal "real".
tomtype cstring "string".
tomtype cbool "o".
tomtype (tid N) S :- copyty (stid S) (tid N).
tomtype (cr A B) S :- tomtype A Am1, tomtype B Bm,
  ((not (primitive A), Am is ("(" ^ Am1 ^ ")"));
   (primitive A, Am = Am1)),
  S is (Am ^ " -> " ^ Bm).



% utils
  
type mkcompound string -> int -> string -> o.
type mkc_aux int -> string -> o.
mkcompound F 0 S :-
  S is ("compound " ^ F ^ ".\n").
mkcompound F N S :- N > 0, 
  mkc_aux N S1,
  S is ("compound (" ^ F ^ " " ^ S1 ^ ").\n").
mkc_aux 1 "A1".
mkc_aux N S :- N > 1,  N1 is (N - 1),
  mkc_aux N1 Rs,
  term_to_string N Ns, S is ("A" ^ Ns ^ " " ^ Rs).
  

type gensym string -> int -> string -> o.
gensym S I S1 :- 
  term_to_string I IS,
  S1 is (S ^ IS).

type makestring cterm -> string -> o.
makestring (sid N) N.
makestring (cid N) S :-  term_to_string N Ns,
  S is ( "(id " ^ Ns ^ ")" ).
makestring (capp A B) S :-
  makestring A As, makestring B Bs,
  S is ( "(capp " ^ As ^ " " ^ Bs ^ ")" ).

type arity ctype -> int -> o.
arity T 0 :- primitive T.
arity (cr A B) T :- arity B S, T is (S + 1).

%postau std_out (cid 5) "f" (cr (cr cint creal) creal) 0 "L".
%pi U1\ (pi V1\ ( ((pi U1p\ (((cabs U1p) = U1) => pi v2\ ( (pi M2\ (pi N2\ ( (N2 is (M2 - L)) => (tau cint ind N v2 M2)))) => ( (L2 is (L + 1)) => (tau creal U1p (V1 v2) L2)) )))) => ((tau creal (capp (id 5) U1) (f V1) L)) ))



