% COL - Scheme Meta-Compiler.

% the scheme meta-compiler is easiest since the language is untyped.

module mcs.
accumulate colsigparser.  % accumulates colgram accumulates corecol


%top level predicate
colsmc Sig :-
  S2 is (Sig ^ ".col"),
  parsefile S2 (csig CS),
  LMod is (Sig ^ ".sch"),
  LClt is (Sig ^ "clt.sch"),   % client functions
  open_out LMod LM, open_out LClt LC,
  output LC "; This file was automatically generated by mcs \n\n",
  output LM "; This file was automatically generated by mcs \n\n",
  output LM "(load \"colscheme.sch\")\n\n",
  % generate invmatch relation
  output LM "(define (invmatch i)\n  (cond\n",
  geninvmatch LM CS 0,
  output LM "\t(#t '())))\n\n",
  % generate match relation
  output LM "(define (match c)\n  (cond \n",
  genmatch LM CS 0,
  output LM "\t (#t 'error)))\n",
  output LC "(load \"", output LC LMod, output LC "\")\n\n",
  genclient LC CS,
  close_out LM, close_out LC.


% note geninvmatch returns an int i, not (id i) by convention
type geninvmatch, genmatch out_stream -> list decl -> int -> o.
type genclient out_stream -> list decl -> o.
geninvmatch OM [] L.
geninvmatch OM [kinddec T|R] L :- L1 is (L + 1),
  geninvmatch OM R L1.
geninvmatch OM [typedec F T|R] L :- L1 is (L + 1),
  output OM "\t ((= i ",
  printterm OM L, output OM ") '", output OM F, output OM ")",
  output OM " ;COL type: ", printterm OM T, output OM "\n",
  geninvmatch OM R L1.

genmatch OM [] L.
genmatch OM [kinddec T|R] L :- L1 is (L + 1),
  genmatch OM R L1.
genmatch OM [typedec F T|R] L :- L1 is (L + 1),
  output OM "\t ((eq? c '", output OM F, output OM ") '(id ",
  printterm OM L, output OM "))\n",
  genmatch OM R L1.

genclient OM [].
genclient OM [kinddec T|R] :- genclient OM R.
genclient OM [typedec F0 T|R] :-
  F is (F0 ^ "R"),
  arity T Ta,
  genhead F Ta Hs,
  output OM "(define ", output OM Hs, output OM "\n",
  output OM "  (let ((s (open_col_session \"localhost\")))\n",
  ((Ta = 0, output OM "     (let ((r (remote_eval '", output OM F0);
   (Ta > 0, output OM "     (let ((r (remote_eval (list '",
    output OM F0, genargs Ta Args, output OM Args)),
  output OM " user-initial-environment s)))\n",
  output OM "       (begin (close_col_session s) r))))\n\n",
  genclient OM R.


% utils

type genhead string -> int -> string -> o.
type genargs int -> string -> o.
genhead F Ta Hs :- 
  genargs Ta Args,
  Hs is ("(" ^ F ^ Args).

genargs 0 ")".
genargs N S :- N > 0, N1 is (N - 1),
  term_to_string N Ns,
  Arg is (" x" ^ Ns),
  genargs N1 Rest,
  S is (Arg ^ Rest).

type arity ctype -> int -> o.
arity T 0 :- primitive T.
arity (cr A B) T :- arity B S, T is (S + 1).

type primitive ctype -> o.
primitive cint.
primitive creal.
primitive cstring.
primitive cbool.
primitive (stid S).
primitive (tid N).







