module usecircles.
accumulate circles.


incircle (point X Y) (circle (point X0 Y0) Radius) :-
   session C,
   remote_eval C (dist X Y X0 Y0) D,
   D < Radius.

intersect (circle (point X0 Y0) R0) (circle (point X1 Y1) R1) :-
   session C,
   remote_eval C (dist X0 Y0 X1 Y1) D,
   RD is (R1 + R2),
   D < RD.

bigcircle (circle (point X Y) Radius) :-
   session C,
   remote_eval C (circu Radius) Circum,
   Circum > 20.0.

test Circ :-
  open_col_session "localhost" C,
  (session C => (
     printterm std_out Circ,
     ((bigcircle Circ, print " is a big circle\n"); 
      print " is not very big\n"), !,
     remote_eval C (dist 0 0 5 5) D,
     printterm std_out D, print " is (dist 0 0 5 5)\n",
     remote_eval C (square (square 3)) S2,
     printterm std_out S2, print " is 3 squared twice\n",
%     print "circle files:\n",
%     remote_eval C (shell "ls circle*") RS, RS > 0
     true
  )),
  close_col_session C.


% procedure:

% write circles.col
% tjsim -s "colcmc \"circles\"." mcc - generates circlessrv.h, .c
% tjsim -s "collpmc \"circles\"." mclp - generates circles.sig, .mod
% write circlesimp.c to implement functions
% compile server with 
% gcc -lnsl -lsocket -lm colcserver.c circlessrv.c circlesimp.c -o circsrv
% write this file, which accumulates circles module.
% run circsrv - it will listen on port 20027
