module uselists.
accumulate lists.

% convert lp lists to lists lists (not COL lists!)
type convtuplist (list int) -> tuple -> o.
convtuplist [] nul.
convtuplist [H|T] (new H S) :- convtuplist T S.

test L :- 
  convtuplist L T,
  open_col_session "localhost" S,
    callscheme S (size T) LN,
    print "the size of the list is ", printterm std_out LN,
    callscheme S (fold plus T) Sum,
    print "\nthe sum of the list (called with fold) is ", printterm std_out Sum,
    callscheme S (mapfn (x\ (plus x 1)) T) TM, convtuplist M TM,
    print "\nand here's the list with everything incremented (called with mapfn):\n  ",
    printterm std_out M, print "\n",
  close_col_session S.

% convtuplist is required to avoid writing lists like ((new 3) nul).
% Note, that ((new 3) nul) is NOT a COL list: there are no lists in COL.
% Wrather, it is a term of lists.sig, which was 
% translated from the COL signature lists.col
